<!--
	INPUT

	<model @_container>
	   MARKUP
	   <element @_id @name @minOccurs @maxOccurs/>
	   <attribute @_id @use @default @fixed/>
	   GROUPING
	   <sequence|choice @_id @minOccurs @maxOccurs/>
	   <list|union/>
	   <mixed/>
	   VALUES
	   <type/>
	   <enumeration|pattern|minInclusive|... @value/>
	   MEANING
	   <documentation @source @_name @_value @_option/>
	</model>

	$option, $function, $value, $context, $textBefore, $textAfter

	OUTPUT

	<style><OL>type<OL>[<TABLE>meaning</TABLE>][<FORM>entry</FORM>]</style>
-->

<xsl:stylesheet
   xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
   xmlns:xt="http://www.jclark.com/xt"
   version="1.0">

<xsl:template match="/">
<xsl:element name="style">
<xsl:apply-templates select="model"/>
</xsl:element>
</xsl:template>

<xsl:template match="*"/> <!-- more specific template overrules -->

<xsl:template match="model">
<!--
********
* TYPE *
********
-->
<OL>
<xsl:variable name="attribute" select=".//attribute[contains(@use, 'required') or $option = 'true' and not($function = 'edit' and count(@fixed) > 0)]"/> <!-- attribute might occur in sequence (extension) -->
<!-- ATTRIBUTES -->
<xsl:if test="count($attribute) > 0">
<LI><EM CLASS="header">attribute</EM></LI>
<OL><xsl:apply-templates select="$attribute"/></OL>
</xsl:if>
<!--
***********
* CONTENT *
***********
-->
<xsl:if test="count(.//*[not(contains('attribute|sequence|documentation', name(.)))]) > 0"> <!-- content? -->
<LI>
<EM CLASS="header">content</EM>
<xsl:if test="count(mixed) > 0"><EM CLASS="valueIndent">text containing</EM></xsl:if>
<xsl:if test="count(type) > 0"><EM CLASS="valueIndent"><xsl:value-of select="type"/></EM></xsl:if>
</LI>
<xsl:choose><xsl:when test="contains('choice|sequence', @_container)">
<OL>
<LI><EM CLASS="group"><xsl:value-of select="@_container"/></EM></LI>
<OL><xsl:apply-templates select="*"><xsl:with-param name="nested">true</xsl:with-param></xsl:apply-templates></OL>
</OL>
</xsl:when><xsl:otherwise>
<OL>
<xsl:apply-templates select="*[not(contains('attribute|enumeration', name(.)))]"/> <!-- processed somewhere else -->
<xsl:if test="count(enumeration) > 0"><LI><EM CLASS="group">choose</EM></LI><OL><xsl:apply-templates select="enumeration"/></OL></xsl:if>
</OL>
</xsl:otherwise></xsl:choose>
</xsl:if>
</OL>
<!--
***********
* MEANING *
***********
-->
<xsl:variable name="documentation" select=".//documentation[$option = 'true' or @_option != '0' or @_option = 'required']"/>
<xsl:if test="count($documentation) > 0">
<TABLE>
<TR><TH>meaning</TH></TR>
<xsl:for-each select="$documentation">
<xsl:sort select="@_name"/>
<xsl:sort select="@_value"/>
<TR><TD>
<xsl:if test="count(@_name) > 0"><A><xsl:value-of select="@_name"/></A><xsl:text> - </xsl:text></xsl:if>
<xsl:if test="count(@_value) > 0"><EM CLASS="value"><xsl:value-of select="@_value"/></EM><xsl:text> - </xsl:text></xsl:if>
<xsl:copy-of select="node()"/>
<xsl:if test="count(@source) > 0">
<A TARGET="_blank">
<xsl:attribute name="HREF"><xsl:value-of select="@source"/></xsl:attribute>
<xsl:value-of select="@source"/>
</A>
</xsl:if>
</TD></TR>
</xsl:for-each>
</TABLE>
</xsl:if>
<!--
*********
* ENTRY *
*********
-->
<!-- value set: enumeration (pattern?) is more restrictive than built in type -->
<xsl:variable name="leaf" select=".//type|.//enumeration|.//pattern"/>
<xsl:if test="$function = 'edit' and ($context = 'true' or count($leaf) > 0)">
<FORM><TABLE>
<TR><TH>entry</TH></TR>
<xsl:if test="$context = 'true'">
<TR><TD>
<TEXTAREA WRAP="virtual" ROWS="5">
<xsl:attribute name="ONBLUR">
<xsl:text>javascript: parent.schemaFrame.document.xsapplet.setTextBefore(value)</xsl:text>
</xsl:attribute>
<xsl:choose><xsl:when test="normalize-space($textBefore) = ''"><xsl:text>
</xsl:text>
</xsl:when><xsl:otherwise><xsl:value-of select="$textBefore"/>
</xsl:otherwise></xsl:choose>
</TEXTAREA>
</TD></TR>
</xsl:if>
<xsl:if test="count($leaf) > 0">
<TR><TD>
<xsl:choose><xsl:when test="count(.//enumeration) > 0">
<SELECT>
<xsl:attribute name="ONBLUR">
<xsl:text>javascript: parent.schemaFrame.document.xsapplet.setText(options[selectedIndex].value)</xsl:text>
</xsl:attribute>
<OPTION VALUE="">undefined</OPTION>
<xsl:for-each select=".//enumeration">
<OPTION>
<xsl:attribute name="VALUE"><xsl:value-of select="@value"/></xsl:attribute>
<xsl:if test="@value = $value"><xsl:attribute name="SELECTED">true</xsl:attribute></xsl:if>
<xsl:value-of select="@value"/>
</OPTION>
</xsl:for-each>
</SELECT>
</xsl:when><xsl:otherwise>
<INPUT TYPE="text">
<xsl:attribute name="ONBLUR">
<xsl:text>javascript: parent.schemaFrame.document.xsapplet.setText(value)</xsl:text>
</xsl:attribute>
<xsl:attribute name="VALUE"><xsl:value-of select="$value"/></xsl:attribute>
</INPUT>
</xsl:otherwise></xsl:choose>
</TD></TR>
</xsl:if>
<xsl:if test="$context = 'true'">
<TR><TD>
<TEXTAREA WRAP="virtual" ROWS="5">
<xsl:attribute name="ONBLUR">
<xsl:text>javascript: parent.schemaFrame.document.xsapplet.setTextAfter(value)</xsl:text>
</xsl:attribute>
<xsl:choose><xsl:when test="normalize-space($textAfter) = ''"><xsl:text>
</xsl:text>
</xsl:when><xsl:otherwise><xsl:value-of select="$textAfter"/>
</xsl:otherwise></xsl:choose>
</TEXTAREA>
</TD></TR>
</xsl:if>
</TABLE></FORM>
</xsl:if>
</xsl:template>

<xsl:template match="attribute">
<LI>
<A>
<xsl:if test="count(@fixed) = 0">
<xsl:attribute name="HREF">
<xsl:text>javascript:parent.schemaFrame.down(</xsl:text>
<xsl:value-of select="@_id"/>
<xsl:text>)</xsl:text>
</xsl:attribute>
</xsl:if>
<xsl:value-of select="@name"/>
</A>
<xsl:if test="not(contains(@use, 'required'))">
<EM CLASS="option">optional</EM>
</xsl:if>
<xsl:if test="count(@default) > 0">
<EM CLASS="labelIndent">DEFAULT</EM><EM CLASS="valueIndent"><xsl:value-of select="@default"/></EM>
</xsl:if>
<xsl:if test="count(@fixed) > 0">
<EM CLASS="labelIndent">FIXED</EM><EM CLASS="valueIndent"><xsl:value-of select="@fixed"/></EM>
</xsl:if>
</LI>
</xsl:template>

<xsl:template name="occurs">
<xsl:if test="count(@minOccurs) > 0 or count(@maxOccurs) > 0">
<EM CLASS="option">
<xsl:choose><xsl:when test="count(@minOccurs) > 0">
<xsl:value-of select="@minOccurs"/>
</xsl:when><xsl:otherwise>
<xsl:text>1</xsl:text> <!-- default -->
</xsl:otherwise></xsl:choose>
<xsl:text>..</xsl:text>
<xsl:choose><xsl:when test="count(@maxOccurs) > 0">
<xsl:value-of select="@maxOccurs"/>
</xsl:when><xsl:otherwise>
<xsl:text>1</xsl:text> <!-- default -->
</xsl:otherwise></xsl:choose>
</EM>
</xsl:if>
</xsl:template>

<xsl:template match="list">
<LI>
<EM CLASS="group">list</EM>
<EM CLASS="valueIndent"><xsl:value-of select="type"/></EM>
</LI>
<OL><xsl:apply-templates select="*"/></OL>
</xsl:template>

<xsl:template match="union">
<LI><EM CLASS="group">choose</EM></LI>
<OL>
<xsl:for-each select="type">
<LI><EM CLASS="label">TYPE</EM><EM CLASS="valueIndent"><xsl:value-of select="."/></EM></LI>
</xsl:for-each>
<xsl:apply-templates select="*"/>
</OL>
</xsl:template>

<xsl:template match="choice|sequence">
<xsl:if test="$option = 'true' or count(@minOccurs) = 0 or @minOccurs != '0'">
<xsl:param name="nested"/>
<xsl:choose><xsl:when test="$function = 'edit' and (not(contains('1', @maxOccurs)) or $nested = 'true')"> <!-- group is repeating or nested -->
<LI>
<A>
<xsl:attribute name="HREF">
<xsl:text>javascript: parent.schemaFrame.down(</xsl:text>
<xsl:value-of select="@_id"/>
<xsl:text>)</xsl:text>
</xsl:attribute>
<xsl:for-each select=".//element"><xsl:value-of select="@name"/><xsl:text> </xsl:text></xsl:for-each>
</A>
<xsl:call-template name="occurs"/>
</LI>
</xsl:when><xsl:otherwise>
<LI><EM CLASS="group"><xsl:value-of select="name(.)"/></EM><xsl:call-template name="occurs"/></LI>
<OL>
<xsl:apply-templates select="*[name(.) != 'attribute']"><xsl:with-param name="nested">true</xsl:with-param></xsl:apply-templates>
</OL>
</xsl:otherwise></xsl:choose>
</xsl:if>
</xsl:template>

<xsl:template match="element">
<xsl:if test="$option = 'true' or count(@minOccurs) = 0 or @minOccurs != '0'">
<LI>
<A>
<xsl:attribute name="HREF">
<xsl:text>javascript: parent.schemaFrame.down(</xsl:text>
<xsl:value-of select="@_id"/>
<xsl:text>)</xsl:text>
</xsl:attribute>
<xsl:value-of select="@name"/>
</A>
<xsl:call-template name="occurs"/>
</LI>
</xsl:if>
</xsl:template>

<xsl:template match="pattern">
<LI><EM CLASS="label">PATTERN</EM><EM CLASS="valueIndent"><xsl:value-of select="@*"/></EM></LI>
</xsl:template>

<xsl:template match="enumeration">
<LI><EM CLASS="label">VALUE</EM><EM CLASS="valueIndent"><xsl:value-of select="@value"/></EM></LI>
</xsl:template>

<xsl:template match="minInclusive">
<LI><EM CLASS="label">greater than or equal to</EM><EM CLASS="valueIndent"><xsl:value-of select="@value"/></EM></LI>
</xsl:template>

<xsl:template match="minExclusive">
<LI><EM CLASS="label">greater than</EM><EM CLASS="valueIndent"><xsl:value-of select="@value"/></EM></LI>
</xsl:template>

<xsl:template match="maxExclusive">
<LI><EM CLASS="label">less than</EM><EM CLASS="valueIndent"><xsl:value-of select="@value"/></EM></LI>
</xsl:template>

<xsl:template match="maxInclusive">
<LI><EM CLASS="label">less than or equal to</EM><EM CLASS="valueIndent"><xsl:value-of select="@value"/></EM></LI>
</xsl:template>

</xsl:stylesheet>